/*
 * File:    mcf5xxx.s
 * Purpose: Lowest level routines for all ColdFire processors.
 *
 * Notes:   
 *
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

    .global mcf5xxx_wr_vbr
    .global _mcf5xxx_wr_vbr
    .global mcf5xxx_wr_sr
    .global _mcf5xxx_wr_sr
    .text

/********************************************************************/
/*
 * These routines write to the special purpose registers in the ColdFire
 * core.  Since these registers are write-only in the supervisor model,
 * no corresponding read routines exist.
 */

 
mcf5xxx_wr_sr:
_mcf5xxx_wr_sr:
    move.l  4(SP),D0
    move.w  D0,SR
    rts
  
mcf5xxx_wr_vbr:
_mcf5xxx_wr_vbr:
    move.l  4(SP),D0
    .long   0x4e7b0801      // movec d0,VBR 
    nop
    rts

/********************************************************************/
    .end
